<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = mysqli_real_escape_string($conn, $_POST['name'] ?? '');
    $reason = mysqli_real_escape_string($conn, $_POST['reason'] ?? '');
    $time_in = mysqli_real_escape_string($conn, $_POST['time_in'] ?? '');

    if ($name && $reason) {
        $stmt = $conn->prepare("INSERT INTO visitors (name, reason, time_in) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $name, $reason, $time_in);
        $stmt->execute();
        $stmt->close();
        $_SESSION['message'] = "Visitor logged successfully.";
    } else {
        $_SESSION['message'] = "All fields are required.";
    }

    header("Location: dashboard.php");
    exit();
} else {
    header("Location: dashboard.php");
    exit();
}
